% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co_relevels.R
\name{co_relevels}
\alias{co_relevels}
\title{Reorder Two Columns Levels Simultaneously}
\usage{
co_relevels(df, primary, secondary, levels_primary)
}
\arguments{
\item{df}{(\code{data.frame}) with two column whose factors should be reordered.}

\item{primary}{(\code{string}) the name of the column on which the levels reordering should be based.}

\item{secondary}{(\code{string}) the name of the column whose levels should be reordered following the levels of the
primary column.}

\item{levels_primary}{(\code{character}) the levels in the desired order. Existing levels that are not included will be
placed afterward in their current order.}
}
\value{
a \code{data.frame} with the \code{secondary} column converted to factor with reordered levels.
}
\description{
Reorder Two Columns Levels Simultaneously
}
\details{
The function expect a 1:1 matching between the elements of the two selected column.
}
\examples{
df <- data.frame(
  SUBJID = 1:3,
  PARAMCD = factor(c("A", "B", "C")),
  PARAM = factor(paste("letter", LETTERS[1:3]))
)
co_relevels(df, "PARAMCD", "PARAM", levels_primary = c("C", "A", "B"))
}
