% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fun_Calib-assist.R
\name{calib_assist}
\alias{calib_assist}
\title{Assist calibration of DYRESM-CAEDYM model.}
\usage{
calib_assist(
  cal.para,
  combination = "random",
  n,
  model.var,
  phyto.group = NA,
  obs.data,
  objective.function = c("NSE", "RMSE"),
  start.date,
  end.date,
  dycd.wd,
  dycd.output,
  file.name,
  verbose = TRUE,
  parallel = FALSE,
  n.cores = NULL,
  write.out = TRUE
)
}
\arguments{
\item{cal.para}{a data frame or a character string naming an external
.csv file where below column names are mandatory: "Parameter" describing
parameter names (abbreviation is allowed), "Min", "Max", and
"Increment" describing the minimum and maximum parameter values
and expected increment in the value range, "Input_file" and
"Line_NO" listing in which configuration file at which line
the parameter can be found.}

\item{combination}{a vector of string character of how to pick up
combinations of parameter values. "random" - the function randomly
picks up a given number of combinations; "all" - the function tries
all possible combinations of parameter values.}

\item{n}{the number of random selections.
Must be provided if combination = "random".}

\item{model.var}{a vector of string character of modelled
variables for calibration. the character should be from the
'var.name' column of 'data(output_name)'.
Note that if model calibration needs to regard chlorophyll
of multiple phytoplankton groups as a whole,
model.var should use "CHLA" and individual phytoplankton group
should be specified through the "phyto.group" argument.
If phytoplankton groups are separately calibrated,
simply list their character in this argument (model.var).}

\item{phyto.group}{a vector of simulated phytoplankton groups,
including CHLOR, FDIAT, NODUL, CYANO and CRYPT.}

\item{obs.data}{a data frame or a character string naming a csv file of
observed lake data.
The observed lake data need to include below columns:
 1) 'Date' in format of "\%Y-\%m-\%d"
 2) 'Depth' (integer)
 3) Water quality variables (use string characters of model var
    as column names).
 see example data 'data(obs_temp)'.}

\item{objective.function}{a vector of string character describing which
objective function(s) to be used for calibration. Selected from
the following five functions:
"NSE": Nash-Sutcliffe efficiency coefficient,
"RMSE": Root Mean Square Error,
"MAE": Mean Absolute Error,
"RAE": Relative Absolute Error,
"Pearson": Pearson's r.}

\item{start.date, end.date}{the beginning and end simulation dates
for the intended DYRESM-CAEDYM calibration.
The date format must be "\%Y-\%m-\%d".
The two dates should be consistent with model configurations.}

\item{dycd.wd}{the directory where input files (including the bat file)
to DYRESM-CAEDYM are stored.}

\item{dycd.output}{a character string naming the output file of
model simulation.}

\item{file.name}{a character string naming a .csv file where
the results of this function are written to. Needed if 'write.out'
= TRUE.}

\item{verbose}{if TRUE, model calibration information is printed.}

\item{parallel}{if TRUE, the calibration process is run on multiple cores.}

\item{n.cores}{When 'parallel' is TRUE, n.cores is the number of cores
the calibration function will be run on. If not provided,
the default value is the number of available cores on the computer -1.}

\item{write.out}{if TRUE, model calibration results are saved in a file
with a file name set by the "file.name" argument.}
}
\value{
a data frame of all tested values of parameters and
 corresponding values of the objective function(s).
}
\description{
This function carries out simulations with a large number
of possible combinations of parameter values that users regard as
potentially suitable for their model calibration, and calculates
the values of nominated objective functions (i.e., statistical measures
of goodness of fit) for each combination. Based on the calculated
objective function values, users can determine the optimal set(s)
of parameter values or narrow the ranges of possible parameter values.
}
\note{
No executable examples are provided to illustrate the
 use of this function, as this function relies on the
 DYRESM-CAEDYM executables to work.
}
