% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update.dynamitefit}
\alias{update.dynamitefit}
\title{Update Dynamite Model}
\usage{
\method{update}{dynamitefit}(
  object,
  dformula = NULL,
  data = NULL,
  priors = NULL,
  recompile = NULL,
  ...
)
}
\arguments{
\item{object}{[\code{dynamitefit}]\cr The model fit object.}

\item{dformula}{[\code{dynamiteformula}]\cr Updated model formula. By default
the original formula is used.}

\item{data}{[\code{data.frame}, \code{tibble::tibble}, or \code{data.table::data.table}]\cr Data for
the updated model. By default original data is used.}

\item{priors}{[\code{data.frame}]\cr Updated priors. By default the priors of
the original model are used.}

\item{recompile}{[\code{logical(1)}]\cr Should the model be recompiled? If
\code{NULL} (default), tries to avoid recompilation. Recompilation is forced when
the model formula or priors are changed, or if the new data contains
missing values in a channel which did not contain missing values in the
original data. Recompilation is also forced in case the backend previous or
new backend is \code{cmdstanr}.}

\item{...}{Additional parameters to \code{dynamite}.}
}
\value{
Updated \code{dynamitefit} object.
}
\description{
Update Dynamite Model
}
\examples{
\dontrun{
# re-estimate the example fit without thinning:
# As the model is compiled on Windows, this will fail on other platforms
if (.Platform$OS.type == "windows") {
  fit <- update(gaussian_example_fit, thin = 1)
}
}

}
