% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_backbone.R
\name{backbone}
\alias{backbone}
\title{Backbone of the simulation model}
\usage{
backbone(module_info, module_network, expression_patterns)
}
\arguments{
\item{module_info}{A tibble containing meta information on the modules themselves.
\itemize{
\item module_id (character): the name of the module
\item basal (numeric): basal expression level of genes in this module, must be between [0, 1]
\item burn (logical): whether or not outgoing edges of this module will
be active during the burn in phase
\item independence (numeric): the independence factor between regulators of this module, must be between [0, 1]
}}

\item{module_network}{A tibble describing which modules regulate which other modules.
\itemize{
\item from (character): the regulating module
\item to (character): the target module
\item effect (integer): \code{1L} if the regulating module upregulates
the target module, \code{-1L} if it downregulates
\item strength (numeric): the strength of the interaction
\item hill (numeric): hill coefficient, larger than 1 for positive cooperativity,
between 0 and 1 for negative cooperativity
}}

\item{expression_patterns}{A tibble describing the expected expression pattern
changes when a cell is simulated by dyngen. Each row represents one transition between
two cell states.
\itemize{
\item from (character): name of a cell state
\item to (character): name of a cell state
\item module_progression (character): differences in module expression between the two states.
Example: \code{"+4,-1|+9|-4"} means the expression of module 4 will go up at the same time as module 1 goes down;
afterwards module 9 expression will go up, and afterwards module 4 expression will go down again.
\item start (logical): Whether or not this from cell state is the start of the trajectory
\item burn (logical): Whether these cell states are part of the burn in phase. Cells will
not get sampled from these cell states.
\item time (numeric): The duration of an transition.
}}
}
\value{
A dyngen backbone.
}
\description{
A module is a group of genes which, to some extent, shows the same
expression behaviour. Several modules are connected together such that
one or more genes from one module will regulate the expression of
another module. By creating chains of modules, a dynamic behaviour in gene
regulation can be created.
}
\examples{
library(tibble)
backbone <- backbone(
  module_info = tribble(
    ~module_id, ~basal, ~burn, ~independence,
    "M1",       1,      TRUE,  1,
    "M2",       0,      FALSE, 1,
    "M3",       0,      FALSE, 1
  ),
  module_network = tribble(
    ~from, ~to,  ~effect, ~strength, ~hill,
    "M1",  "M2", 1L,      1,         2,
    "M2",  "M3", 1L,      1,         2
  ), 
  expression_patterns = tribble(
    ~from, ~to,  ~module_progression, ~start, ~burn, ~time,
    "s0",  "s1", "+M1",               TRUE,   TRUE,  15,
    "s1",  "s2", "+M2,+M3",           FALSE,  FALSE, 30
  )
)

\donttest{
model <- 
  initialise_model(backbone = backbone) \%>\%
  generate_tf_network() \%>\%
  generate_feature_network() \%>\%
  generate_kinetics() \%>\%
  generate_gold_standard() \%>\%
  generate_cells() \%>\%
  generate_experiment() 
  
dataset <- wrap_dataset(model)
}
}
\seealso{
\code{\link[=list_backbones]{list_backbones()}} for a list of all backbone methods.
}
