% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_experiment.R
\name{generate_experiment}
\alias{generate_experiment}
\alias{list_experiment_samplers}
\alias{experiment_snapshot}
\alias{experiment_synchronised}
\title{Sample cells from the simulations}
\usage{
generate_experiment(model)

list_experiment_samplers()

experiment_snapshot(
  realcount = NULL,
  sample_capture_rate = function(n) rnorm(n, 1, 0.05) \%>\% pmax(0),
  weight_bw = 0.1
)

experiment_synchronised(
  realcount = NULL,
  sample_capture_rate = function(n) rnorm(n, 1, 0.05) \%>\% pmax(0),
  num_timepoints = 8,
  pct_between = 0.75
)
}
\arguments{
\item{model}{A dyngen intermediary model for which the simulations have been run with \code{\link[=generate_cells]{generate_cells()}}.}

\item{realcount}{The name of a dataset in \link{realcounts}. If \code{NULL}, a random
dataset will be sampled from \link{realcounts}.}

\item{sample_capture_rate}{A function that samples values for the simulated capture rates of genes.}

\item{weight_bw}{[snapshot] A bandwidth parameter for determining the distribution of
cells along each edge in order to perform weighted sampling.}

\item{num_timepoints}{[synchronised] The number of time points used in the experiment.}

\item{pct_between}{[synchronised] The percentage of 'unused' simulation time.}
}
\value{
A dyngen model.
}
\description{
\code{\link[=generate_experiment]{generate_experiment()}} runs samples cells along the different simulations.
\code{\link[=experiment_snapshot]{experiment_snapshot()}} assumes that cells are sampled from a heterogeneous pool of cells.
Cells will thus be sampled uniformily from the trajectory.
\code{\link[=experiment_synchronised]{experiment_synchronised()}} assumes that all the cells are synchronised and
are sampled at different timepoints.
}
\examples{
names(list_experiment_samplers())

model <- 
  initialise_model(
    backbone = backbone_bifurcating(),
    experiment = experiment_synchronised()
  )

\donttest{
model <- 
  model \%>\%
  generate_tf_network() \%>\%
  generate_feature_network() \%>\%
  generate_kinetics() \%>\%
  generate_gold_standard() \%>\%
  generate_cells() \%>\%
  generate_experiment() 
  
dataset <- wrap_dataset(model)
}
}
