% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_character.R
\name{character_parameter}
\alias{character_parameter}
\title{Define a character / string parameter}
\usage{
character_parameter(id, default, values, description = NULL,
  tuneable = TRUE)
}
\arguments{
\item{id}{The name of the parameter.}

\item{default}{The default value of the parameter.}

\item{values}{A set of possible values.}

\item{description}{An optional (but recommended) description of the parameter.}

\item{tuneable}{Whether or not a parameter is tuneable.}
}
\description{
Define a character / string parameter
}
\examples{
character_parameter(
  id = "method",
  default = "pearson",
  values = c("pearson", "spearman", "kendall"),
  description = "Which correlation coefficient to compute."
)
}
\seealso{
\link{dynparam} for an overview of all dynparam functionality.
}
