% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{prep.formulaDynamics}
\alias{prep.formulaDynamics}
\title{Recipe function for specifying dynamic functions using formulas}
\usage{
prep.formulaDynamics(formula, startval = numeric(0),
  isContinuousTime = FALSE, jacobian)
}
\arguments{
\item{formula}{a list of formulas specifying the drift or state-transition 
equations for the latent variables in continuous or discrete time, respectively.}

\item{startval}{a named vector of starting values of the parameters in the 
formulas for estimation with parameter names as its name. If there are no free parameters in 
the dynamic functions, leave startval as the default \code{numeric(0)}.}

\item{isContinuousTime}{if True, the left hand side of the formulas represent 
the first-order derivatives of the specified variables; if False, the left hand 
side of the formulas represent the current state of the specified variable while 
the same variable on the righ hand side is its previous state.}

\item{jacobian}{(optional) a list of formulas specifying the analytic jacobian matrices 
containing the analytic differentiation function of the dynamic functions with respect to
the latent variables. If this is not provided, dynr will invoke an automatic differentiation
procedure to compute the jacobian functions.}
}
\description{
Recipe function for specifying dynamic functions using formulas
}
\details{
This function defines the dynamic functions of the model either in discrete time or in continuous time.
The function can be either linear or nonlinear, with free or fixed parameters, numerical constants, 
covariates, and other mathematical functions that define the dynamics of the latent variables.
Every latent variable in the model needs to be defined by a differential (for continuous time model), or
difference (for discrete time model) equation.  The names of the latent variables should match 
the specification in prep.measurement().
For nonlinear models, the estimation algorithm generally needs a Jacobian matrix that contains
elements of first differentiations of the dynamic functions with respect to the latent variables
in the model. For most nonlinear models, such differentiations can be handled automatically by
dynr. However, in some cases, such as when the absolute function (abs) is used, the automatic
differentiation would fail and the user may need to provide his/her own Jacobian functions.
}

