% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6create_extract.R
\name{create_extract}
\alias{create_extract}
\title{Create subset of common family file variables in long format}
\usage{
create_extract(in_direc, out_direc, num_vars = 500, all_years = F)
}
\arguments{
\item{in_direc}{Directory containing waves of the Family Files in .rds format}

\item{out_direc}{Directory to place export file into}

\item{num_vars}{Number of variables to include in export dataset (default = 500). High variable counts with many waves of data require a significant amount of RAM, and may cause this function to throw errors if a computer's RAM is insufficient}

\item{all_years}{Select most common variables based on all years of the PSID rather than based in the data actually supplied}
}
\description{
Creates an extract dataset in long format consisting of the 500 most frequently reoccurring PSID Family Variables across all supplied waves of the PSID.
}
\examples{
create_extract(
    in_direc=system.file("extdata","rds_dir", package = "easyPSID"),
    out_direc=tempdir(),
    num_vars=25,
)
}
\keyword{PSID}
