% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspectMetaDifferences.R
\name{inspectMetaDifferences}
\alias{inspectMetaDifferences}
\title{Inspect meta data differences in a variable.}
\usage{
inspectMetaDifferences(varName, GADSdat1, GADSdat2)
}
\arguments{
\item{varName}{A character vector of length 1 containing the variable name.}

\item{GADSdat1}{A \code{GADSdat} object.}

\item{GADSdat2}{A \code{GADSdat} object.}
}
\value{
A list.
}
\description{
Inspect meta data differences between two \code{GADSdat} objects or \code{GADSdat} data bases regarding a specific variable.
}
\details{
Two \code{GADSdat} objects can be compared using \code{\link{equalGADS}}.
If meta data differences for specific variables in the two objects occur,
these variables can be further inspected using \code{inspectMetaDifferences}.
For data-level differences for a specific variable, see \code{\link{inspectDifferences}}.
}
\examples{
# create a second GADS with different meta data
pisa2 <- pisa
pisa2 <- changeVarLabels(pisa2, varName = "sameteach", varLabel = "Same math teacher")
pisa2 <- recodeGADS(pisa2, varName = "sameteach", oldValues = c(1, 2), newValues = c(0, 1))

# inspect via equalGADS()
equalGADS(pisa, pisa2)

# inspect via inspectMetaDifferences()
inspectMetaDifferences("sameteach", GADSdat1 = pisa, GADSdat2 = pisa2)

}
