% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probtrans_ebmstate.R
\name{probtrans_by_convolution}
\alias{probtrans_by_convolution}
\title{Compute all transition probabilities from a given state
using convolution}
\usage{
probtrans_by_convolution(tmat, cumhaz, from_state, model, max_time, nr_steps)
}
\arguments{
\item{tmat}{A transition matrix extracted from the \code{cumhaz} argument to 
\code{probtrans_ebmstate}.}

\item{cumhaz}{\code{msfit} object (argument passed on from \code{probtrans_ebmstate}).}

\item{from_state}{Initial state (argument passed on from \code{probtrans_ebmstate}).}

\item{model}{'clockforward' or 'clockreset' (argument passed on from \code{probtrans_ebmstate}).}

\item{max_time}{The maximum time for which transition probabilities
are estimated.}

\item{nr_steps}{The number of steps in the convolution algorithm
(larger increases precision but makes it slower)}
}
\description{
\code{probtrans_by_convolution} is an internal function of \code{probtrans_ebmstate} and
is not meant to be called directly by the user.
It is itself a wrapper for the functions \code{probtrans_by_convolution_clockforward}
and \code{probtrans_by_convolution_clockreset}, which are the workhorses of the 
convolution algorithm.
}
\details{
For more information on the arguments of this function 
see \code{\link{probtrans_ebmstate}}.
}
\seealso{
\code{\link{probtrans_ebmstate}};\code{\link{probtrans_by_convolution_clockforward}};
\code{\link{probtrans_by_convolution_clockreset}}.
}
\author{
Rui Costa & Moritz Gerstung
}
