% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{df2table}
\alias{df2table}
\alias{table2df}
\alias{dist2df}
\title{Convert data.frame and table to each other.}
\usage{
df2table(df, st = "stand", sp = "species", ab = "abundance")

table2df(tbl, st = "stand", sp = "species", ab = "abundance")

dist2df(dist)
}
\arguments{
\item{df}{A data.frame.}

\item{st, sp, ab}{A string.}

\item{tbl}{A table. community matrix.
rownames: stands.
colnames: species.}

\item{dist}{A distance table.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{df2table() return table, 
table2df() return data.frame,
dist2df() return data.frame.
}\if{html}{\out{</div>}}
}
\description{
Convert data.frame and table to each other.
}
\examples{
tibble::tibble(
   st = paste0("st_", rep(1:2, times = 2)), 
   sp = paste0("sp_", rep(1:2, each = 2)), 
   ab = runif(4)) \%>\%
  dplyr::bind_rows(., .) \%>\%
  print() \%>\%
  df2table("st", "sp", "ab")

}
