% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{e_axis}
\alias{e_axis}
\alias{e_axis_}
\alias{e_x_axis_}
\alias{e_y_axis_}
\alias{e_z_axis_}
\alias{e_x_axis}
\alias{e_y_axis}
\alias{e_z_axis}
\alias{e_rm_axis}
\alias{e_axis_formatter}
\title{Axis}
\usage{
e_axis(
  e,
  serie,
  axis = c("x", "y", "z"),
  index = 0,
  formatter = NULL,
  margin = 0,
  ...
)

e_axis_(
  e,
  serie = NULL,
  axis = c("x", "y", "z"),
  index = 0,
  formatter = NULL,
  margin = 0,
  ...
)

e_x_axis_(e, serie = NULL, index = 0, formatter = NULL, margin = 0, ...)

e_y_axis_(e, serie = NULL, index = 0, formatter = NULL, margin = 0, ...)

e_z_axis_(e, serie = NULL, index = 0, margin = 0, ...)

e_x_axis(e, serie, index = 0, formatter = NULL, margin = 0, ...)

e_y_axis(e, serie, index = 0, formatter = NULL, margin = 0, ...)

e_z_axis(e, serie, index = 0, margin = 0, ...)

e_rm_axis(e, axis = c("x", "y", "z"))

e_axis_formatter(
  style = c("decimal", "percent", "currency"),
  digits = 0,
  locale = NULL,
  currency = "USD"
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{serie}{Column name of serie to range the axis. If used the range of the serie is used as,
\code{min} an \code{max}.}

\item{axis}{Axis to customise.}

\item{index}{Index of axis to customise.}

\item{formatter}{An axis formatter as returned by \code{\link{e_axis_formatter}}.}

\item{margin}{Margin to apply to \code{serie}: \eqn{min = serie - margin} and
\eqn{max = serie + margin}}

\item{...}{Any other option to pass, check See Also section.}

\item{style}{Formatter style, one of \code{decimal}, \code{percent}, or \code{currency}.}

\item{digits}{Number of decimals.}

\item{locale}{Locale, if \code{NULL} then it is inferred from \code{Sys.getlocale}.}

\item{currency}{Currency to to display.}
}
\description{
Customise axis.
}
\details{
The \code{e_axis_formatter} may not work in RStudio,
open the plot in your browser. It will display just fine in
Rmarkdown and Shiny.
}
\section{Functions}{

\itemize{
  \item{\code{e_axis} to customise axis}
  \item{\code{e_rm_axis} to remove axis}
}
}

\examples{
# range axis based on serie
cars \%>\%
  e_charts(speed) \%>\%
  e_line(dist) \%>\%
  e_x_axis(speed) \%>\%
  e_y_axis(dist)

# use formatter
cars \%>\%
  dplyr::mutate(
    speed = speed / 25
  ) \%>\%
  e_charts(speed) \%>\%
  e_scatter(dist) \%>\%
  e_y_axis(
    formatter = e_axis_formatter("currency")
  ) \%>\%
  e_x_axis(
    formatter = e_axis_formatter("percent", digits = 0)
  )

# plot all labels & rotate
USArrests \%>\%
  head(10) \%>\%
  dplyr::mutate(State = row.names(.)) \%>\%
  e_charts(State) \%>\%
  e_area(Murder) \%>\%
  e_x_axis(axisLabel = list(interval = 0, rotate = 45)) # rotate
}
\seealso{
\href{https://echarts.apache.org/en/option.html#xAxis}{Additional x arguments},
\href{https://echarts.apache.org/en/option.html#yAxis}{Additional y arguments}
}
