% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_demcurve_cond_dem}
\alias{ec_demcurve_cond_dem}
\title{Create demand-incidence curves}
\usage{
ec_demcurve_cond_dem(
  ec_long,
  focal_product,
  rel_pricerange,
  dem_fun,
  draws,
  epsilon_not = NULL
)
}
\arguments{
\item{ec_long}{choice scenario (discrete or volumetric)}

\item{focal_product}{Logical vector picking the focal product for which to create a demand curve}

\item{rel_pricerange}{Price range, relative to base case price; this is used to create demand curve}

\item{dem_fun}{demand function (e.g., \code{dd_prob} for HMNL or \code{vd_dem_vdm} for volumetric demand). For discrete choice, use choice probabilities instead of choice predictions.}

\item{draws}{ec-draws object (e.g., output from \code{dd_est_hmnl} or \code{vd_est_vd})}

\item{epsilon_not}{(optional) error realisatins (this helps make curves look smother for voumetric models)}
}
\value{
List containing aggregate demand quantities for each scenario defined by \code{rel_pricerange}
}
\description{
This helper function creates demand curves
}
\examples{
\donttest{
data(icecream)
#run MCMC sampler (use way more draws for actual use)
icecream_est <- icecream \%>\% dplyr::filter(id<20) \%>\% 
vd_est_vdm(R=2, keep=1, cores=2)
#demand at different price points
conddem_scenarios<-
ec_demcurve_cond_dem(icecream\%>\% dplyr::filter(id<20),
 icecream\%>\% dplyr::filter(id<20) \%>\% pull('Brand')=="Store",
 c(.75,1),vd_dem_vdm,icecream_est)
}

}
\seealso{
\code{\link[=ec_gen_err_normal]{ec_gen_err_normal()}} to generate error realization from Normal distribution,
\code{\link[=ec_gen_err_ev1]{ec_gen_err_ev1()}} to generate error realization from EV1 distribution
}
