\name{ecolMod-package}
\alias{ecolMod-package}
\alias{ecolMod}
\docType{package}
\title{
  A practical guide to ecological modelling - using R as
               a simulation platform
}
\description{
Figures, data sets and examples from the book "A
practical guide to ecological modelling - using R as a
simulation platform" by Karline Soetaert and Peter MJ
Herman (2008). Springer.

All figures from chapter x can
               be generated by \code{demo(chapx)}, where x = 1 to 11.

The R-scripts of the model examples discussed in the book
are in subdirectory "examples", ordered per chapter.

Solutions to model projects are in the same subdirectories.

     }
\details{
  \tabular{ll}{
    Package: \tab ecolMod\cr
    Type: \tab Package\cr
    Version: \tab 1.2\cr
    Date: \tab 2008-10-14\cr
    License: \tab GNU Public License 2 or above\cr
  }
}
\author{
  Karline Soetaert (Maintainer) and Peter M.J. Herman
}
\seealso{
 \item \code{\link{OMEXDIAsteady}} steady-state application of the OMEXDIA
                        diagenetic model - a fortran DLL
 \item \code{\link{SCOC}} a Sediment Community Oxygen Consumption (SCOC) dataset
 \item \code{\link{Zoogrowth}}a zooplankton growth dataset
 \item \code{\link{deepCmin}}  results of the calibration exercise from chapter 4.4.4
 \item \code{\link{dilution}}  Draws dilution culture setup
 \item \code{\link{pricefit}}  Pseudo-random search algorithm of Price (1997)
}
\examples{
\dontrun{
## show examples (see respective help pages for details)
example(pricefit)
example(SCOC)

## run demos
demo("chap1") # chapter 1. Introduction
demo("chap2") # chapter 2. Model formulation
demo("chap3") # chapter 3. Spatial components and transport
demo("chap4") # chapter 4. Parameterisation
demo("chap5") # chapter 5. Model solution - analytical methods
demo("chap6") # chapter 6. Model solution - numerical methods
demo("chap7") # chapter 7. Stability and steady-state
demo("chap8") # chapter 8. Multiple time scales and equilibrium processes
demo("chap9") # chapter 9. Discrete time models
demo("chap10") # chapter 10. Dynamic programming
demo("chap11") # chapter 11. Testing and validating the model

## open the directory with source code of demos
browseURL(paste(system.file(package="ecolMod"), "/demo", sep=""))

## open the directory with book examples
browseURL(paste(system.file(package="ecolMod"), "/examples", sep=""))
}
}

\keyword{ package }