% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximity.R
\name{proximity}
\alias{proximity}
\title{Proximity}
\usage{
proximity(rca, diversity, ubiquity, compute = "both", tbl = TRUE,
  country_r = "country", product_r = "product", value_r = "value",
  country_d = "country", value_d = "value", product_u = "product",
  value_u = "value")
}
\arguments{
\item{rca}{matrix or data.frame with RCA values}

\item{diversity}{matrix or data.frame with diversity values}

\item{ubiquity}{matrix or data.frame with ubiquity values}

\item{compute}{"country", "product" or "both" (default) matrices}

\item{tbl}{TRUE (default) returns a data.frame and FALSE returns a matrix}

\item{country_r}{column containing countries (applies only if d is a
data.frame)}

\item{product_r}{column containing products (applies only if d is a
data.frame)}

\item{value_r}{column containing traded values (applies only if d is a
data.frame)}

\item{country_d}{column containing countries (applies only if d is a
data.frame)}

\item{value_d}{column containing values (applies only if d is a
data.frame)}

\item{product_u}{column containing products (applies only if d is a
data.frame)}

\item{value_u}{column containing values (applies only if d is a
data.frame)}
}
\value{
A list with two data frames or matrices.
}
\description{
\code{proximity} computes proximity
}
\details{
Given a data frame or matrix with RCA values and two data frames or
vectors with diversity and ubiquity values or equivalent data frames, this
function computes proximity by combining tidyverse tools and R base matrix
functions.
}
\examples{
proximity(
  ec_output_demo$rca,
  ec_output_demo$complexity$diversity,
  ec_output_demo$complexity$ubiquity
)

}
\references{
For more information on proximity and its applications see:

\insertRef{atlas2014}{economiccomplexity}

and the references therein.
}
\seealso{
\code{\link[economiccomplexity]{rca}},
\code{\link[economiccomplexity]{complexity}}
}
\keyword{functions}
