% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bipartite_stats.R
\name{bipartite_stats}
\alias{bipartite_stats}
\title{Test for significant differences in a range of network metrics between the
  observed and null bipartite networks}
\usage{
bipartite_stats(nullnet, signif.level = 0.95, index.type, indices,
  prog.count = TRUE, ...)
}
\arguments{
\item{nullnet}{An object of class 'nullnet' from \code{generate_null_net}}

\item{signif.level}{An optional value specifying the threshold used for
testing for 'significant' deviations from the null model.  Defaults to 0.95}

\item{index.type}{String specifying which function to call from the
\code{bipartite} package: \code{specieslevel}, \code{grouplevel} or
\code{networklevel}, according to the level at which the statistics are
required.  For \code{specieslevel}, statistics are calculated for both
'higher' and 'lower' levels i.e. \code{level = "both"} and cannot be
changed: adding a \code{level} argument will produce an error:
statistics from higher and lower levels are easily separated in the output
from \code{bipartite_stats}.}

\item{indices}{Vector listing the bipartite network statistics to calculate.
All indices are currently supported, with the exception of the dependence
matrix: if \code{ALL} is specified, it will default to \code{ALLBUTD}.}

\item{prog.count}{A logical value specifying whether the progress count
should be shown. Defaults to \code{TRUE}.}

\item{...}{Other arguments that may be supplied to \code{bipartite}'s
\code{specieslevel}, \code{grouplevel} or \code{networklevel} functions.}
}
\value{
Returns one or more data frames according to the level at which the
  statistics are calculated (\code{specieslevel, grouplevel} or
  \code{networklevel}).  If \code{index.type = "networklevel"} or
  \code{index.type = "grouplevel"} a single data frame is returned, listing
  the chosen network statistics and with the following column headings:
  \describe{
    \item{\code{Observed}}{Value of the statistic for the observed network}
    \item{\code{Null}}{Mean value of the statistic across the iterations of
      the null model}
    \item{\code{Lower.CL}}{Lower confidence limit for the metric}
    \item{\code{Upper.CL}}{Upper confidence limit for the network metric}
    \item{\code{Test}}{Whether the value of the statistic with the observed
      network is significantly \strong{higher} than expected under the
      null model, \strong{lower} or consistent with the null model
      (\strong{ns})}
    \item{\code{SES}}{The standardised effect size for the difference between
      the observed network and the null model (see Gotelli & McCabe 2002
      for details)}
  }

  If \code{index.type = "specieslevel"}, a list comprising two data frames for
    each statistic, representing the \code{higher} and \code{lower} levels in
    the network. Each data frame has the same format as for
    \code{networklevel} except that the rows are individual nodes (species)
    in the network. See examples for how to call the individual data frames.
}
\description{
Acts as a wrapper for the \code{bipartite} package's
  \code{\link[bipartite]{networklevel}},
  \code{\link[bipartite]{grouplevel}} and
  \code{\link[bipartite]{specieslevel}} functions, allowing a wide range
  of measures to be calculated (Dormann \emph{et al}., 2008, 2009; Dorman
  2011).  These are calculated both for the observed network and across the
  iterations of the null model, allowing for simple tests of whether the
  observed values differ from those expected by chance.
}
\details{
Allows most of the network metrics in the \code{bipartite} package
  to be calculated for an observed bipartite network and compared to the
  distribution of those network metrics across the iterations of the null
  model.  This indicates whether the observed network differs from the
  structure of the network that could be expected if consumers simply used
  resources in proportion to their relative abundance.

  The user sets the significance level (default = 95\% confidence limits),
  and the metrics selected are classified into those that are higher,
  lower or consistent with the null model at that significance level.
  Significance is determined by comparing the observed value of the statistic
  to the 1-alpha/2 percentiles from the frequency distribution, with
  'significant' values falling outside the confidence interval (Manly 2006).
}
\examples{
set.seed(1234)
sil.null <- generate_null_net(Silene[, 2:7], Silene.plants[, 2:6], sims = 10,
                              c.samples = Silene[, 1],
                              r.samples = Silene.plants[, 1])
# Network-level analysis
net.stats <- bipartite_stats(sil.null, index.type = "networklevel",
                             indices = c("linkage density",
                             "weighted connectance", "weighted nestedness",
                             "interaction evenness"), intereven = "sum")
net.stats

# Group-level analysis
grp.stats <- bipartite_stats(sil.null, index.type = "grouplevel",
                             indices = c("generality",
                             "vulnerability", "partner diversity"),
                             logbase = 2)
grp.stats

# Species-level statistics
spp.stats <- bipartite_stats(sil.null, index.type = "specieslevel",
                             indices = c("degree", "normalised degree",
                             "partner diversity"), logbase = exp(1))

spp.stats # Show all data frames of results
spp.stats$normalised.degree # Select one statistic
spp.stats$normalised.degree$lower # Select one statistic at one level

}
\references{
Dormann, C.F., Gruber B. & Frund, J. (2008). Introducing the
  bipartite package: analysing ecological networks. \emph{R news},
  \strong{8}, 8--11.

  Dormann, C.F., Frund, J., Bluthgen, N. & Gruber, B. (2009). Indices, graphs
  and null models: analyzing bipartite ecological networks. \emph{Open
  Ecology Journal} \strong{2}, 7--24.

  Dormann, C.F. (2011) How to be a specialist? Quantifying specialisation
  in pollination networks. \emph{Network Biology}, \strong{1}, 1-20.

  Gotelli, N.J. & McCabe, D.J. (2002) Species co-occurrence: a meta-analysis
  of J.M. Diamond's assembly rules model. \emph{Ecology}, \strong{83},
  2091--2096.

  Manly, B.F.J. (2006) \emph{Randomization, Bootstrap and Monte Carlo Methods
  in Biology} (3rd edn). Chapman & Hall, Boca Raton.

  Vaughan, I.P., Gotelli, N.J., Memmott, J., Pearson, C.E.,
  Woodward, G. and Symondson, W.O.C. (2017) econullnetr: an R package using null
  models to analyse the structure of ecological networks and identify
  resource selection. \emph{Methods in Ecology and Evolution}, in press.
}
\seealso{
\code{\link{generate_null_net}}, \code{\link{plot_bipartite}},
  \code{\link[bipartite]{networklevel}}, \code{\link[bipartite]{grouplevel}},
  \code{\link[bipartite]{specieslevel}}
}

