% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neigh_diff.R
\name{neigh_diff}
\alias{neigh_diff}
\title{A function to find the difference between school district neighbors}
\usage{
neigh_diff(data_year= "2017",
 diff_var="Percentage Point Difference in Poverty Rate", type= "like")
}
\arguments{
\item{data_year}{Four digit year of master data to pull in. Options include
2013- 2017. Defaults to 2017.}

\item{diff_var}{Character string on which to rank the difference between
school district neighbors. Use diff_var = “options” to print a list of the variables.
Defaults to Percentage Point Difference in
Poverty Rate.}

\item{type}{Character string to indicate which types of neighbors to return.
Defaults to "like" which returns a list of neighbors that are the same
district type (that is, unified to unified, elementary to elementary and
secondary to secondary). To view all neighbors use "all". This selection
becomes important for districts like Chicago which have upwards of 50
neighboring school districts, but only 1 type-like neighbor. Chicago is a unified
district and it has 1 neighbor that is also unified, 16 neighbors that are secondary
districts, and 32 neighbors that are elementary districts.}
}
\value{
A dataframe where each observation is a pair of neighboring school
  districts.
}
\description{
This function allows you to find the difference between each pair of school
district neighbors and calculate the national rank from largest to smallest.
}
\examples{
\donttest{tr_diff <- neigh_diff(
           data_year = "2017",
           diff_var = "Difference in Total Revenue Per Pupil"
           )}
}
\seealso{
\code{\link{masterpull}}, \code{\link{master_codebook}},
  \code{\link{sd_neighbor_xlsx}}
}
\keyword{EdBuild}
\keyword{difference}
\keyword{neighbors}
\keyword{rank}
