% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textInput3.R
\name{checkboxInput3}
\alias{checkboxInput3}
\title{Create a side-by-side checkboxInput}
\usage{
checkboxInput3(inputId, label, value = FALSE, width = 100)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value.}

\item{label}{Display label for the control, or NULL for no label.}

\item{value}{Initial value.}

\item{width}{The width of the input in pixel}
}
\description{
Create a side-by-side checkboxInput
}
\examples{
library(shiny)
# Only run examples in interactive R sessions
if (interactive()) {
  ui <- fluidPage(
         label3("Welcome"),
         checkboxInput3("somevalue", "Some value", FALSE),
         verbatimTextOutput("value")
  )
  server <- function(input, output) {
        output$value <- renderText({ input$somevalue })
  }
  shinyApp(ui, server)
}
}
