% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_standardize.R
\name{format_standardize}
\alias{format_standardize}
\title{Transform a standardized vector into character}
\usage{
format_standardize(x, reference = x, robust = FALSE, digits = NULL, ...)
}
\arguments{
\item{x}{A standardized numeric vector.}

\item{reference}{The reference vector from which to compute the mean and SD.}

\item{robust}{Logical, if \code{TRUE}, centering is done by subtracting the
median from the variables and dividing it by the median absolute deviation
(MAD). If \code{FALSE}, variables are standardized by subtracting the
mean and dividing it by the standard deviation (SD).}

\item{digits}{Number of significant digits.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Transform a standardized vector into character, e.g., \code{c("-1 SD", "Mean", "+1 SD")}.
}
\examples{
format_standardize(c(-1, 0, 1))
format_standardize(c(-1, 0, 1, 2), reference = rnorm(1000))
format_standardize(c(-1, 0, 1, 2), reference = rnorm(1000), robust = TRUE)
}
