% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_ego_tergm.R
\name{interpret_ego_tergm}
\alias{interpret_ego_tergm}
\title{Custom interpret function for ego-TERGM.}
\usage{
interpret_ego_tergm(ego_tergm_fit = NULL, custom_var_names = NULL)
}
\arguments{
\item{ego_tergm_fit}{The output from a fitted "ego_tergm".}

\item{custom_var_names}{A vector of character terms in the same order as the form object fed to ego_tergm of clearer names for these variables.}
}
\description{
This function assists the user in interpreting output from the ego_tergm function.
}
\examples{
interpret_ego_tergm(ego_tergm_fit = ego_tergm_fit)
interpret_ego_tergm(ego_tergm_fit = ego_tergm_fit,
                    custom_var_names = c("Edges", "Mutual", "Triangle",
                                        "In-Degree", "Out-Degree", "Sex Homophily"))
}
\references{
{
Campbell, Benjamin W. (2018):
 Inferring Latent Roles in Longitudinal Networks.
 \emph{Political Analysis} 26(3): 292-311.  \url{https://doi.org/10.1017/pan.2018.20}
}
}
\keyword{interpretation}
\keyword{summary}
