% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{transnat}
\alias{transnat}
\alias{alter_df}
\alias{ego_df}
\title{Transnational personal communities of social support of German migrants in Great Britain}
\format{
transnat: an \code{egor} object of 50 egos.

alter_df: alter \code{data.frame} of the transnat dataset.

ego_df: ego \code{data.frame} of the transnat dataset.
}
\usage{
transnat

alter_df

ego_df
}
\description{
This is an \code{egor} object derived from a subset of the data of a personal network
study on support relationships German migrants living in the UK maintain. The data was collected in 2010 using respondent driven sampling (snowball sampling).
While the number of alters the respondents were allowed to enter was not limited, only a random subsample of up to eight alters were selected for the alter name interpreter and alter-alter tie questions.
This data set contains the data
for 50 of the originally 234 egos.
}
\details{
The questionnaire used seven name generators:
\enumerate{
\item From time to time, people rely on other people's advice and opinions to help them find their way in life better. In the last 12 months, who have you sought advice from when it came to important decisions, for example about your family or work? (emotional)
\item In the last 12 months who has done little jobs and favors for you or helped you, for example in filling in forms or moving home? (instrumental)
\item In the past year, who have you turned to when you felt down and wanted someone to talk to? (emotional)
\item In the last 12 months, who have you borrowed money from? (instrumental)
\item In the past year, who have you spent your free time with or shared a hobby? ( social companionship)
\item In the past year who have you had disagreements or arguments with (e.g. about everyday affairs, money or property)? (conflict)
\item Who has let you know that you can rely on them (e.g. that they will always be there for you if you need help)? (emotional).
}
}
\references{
\itemize{
\item Herz, A. (2015). Relational constitution of social support in migrants' transnational personal communities. Social Networks, 40 (1), S. 64-74.
\item Herz, A. (2012). Strukturen transnationaler sozialer Unterstützung. Springer Fachmedien Wiesbaden.
}
}
\keyword{datasets}
