% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elaborator_plot_ref_pattern.R
\name{elaborator_plot_ref_pattern}
\alias{elaborator_plot_ref_pattern}
\title{Generates the reference-value based pattern analysis plots in the shiny app elaborator}
\usage{
elaborator_plot_ref_pattern(
  data,
  criterion,
  fontsize = 0.6,
  sorting_vector = as.character(unique(data[, "PARAMCD"])),
  abnormal_value_factor = 1
)
}
\arguments{
\item{data}{data set}

\item{criterion}{criterion for defining whether abnormal values are defined as values below the lower limit of normal (less), above the upper limit of normal (greater) or either above the upper limit of normal or below the lower limit of normal (within)}

\item{fontsize}{font size of numbers printed inside the circles}

\item{sorting_vector}{vector of laboratory parameter names in the order in which laboratory parameters are presented in the output}

\item{abnormal_value_factor}{numeric which is multiplied with upper and/or lower limit of normal for defining abnormal values; can only take positive values.}
}
\value{
No return value, called to plot the reference-based value pattern.
}
\description{
Generates diagrams showing the frequency of normal and abnormal values at each visit of a study separately by treatment group and laboratory parameter according to the reference-value based pattern analysis.
}
\keyword{internal}
