% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{valid_url}
\alias{valid_url}
\title{Validate Elasticsearch URL.}
\usage{
valid_url(url)
}
\arguments{
\item{url}{The URL to validate.}
}
\value{
Boolean
}
\description{
Tries to defend against incorrect URLs to Elasticsearch rescources. Requires that URLs must
contain the protocol (e.g. 'http') as well an Elasticsearch port number (e.g. ':9200'), and must
not end in '/'.
}
\examples{
\dontrun{
url <- "http://localhost:9200"
valid_url(url)
# TRUE

url <- "localhost:9200"
valid_url(url)
# Error in valid_url(url) : invalid URL to Elasticsearch cluster
}
}

