% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_adjust.R
\name{p.adjust}
\alias{p.adjust}
\title{Adjust P-values for Multiple Test Procedures}
\usage{
p.adjust(p, method = "gtxr", n = length(p))
}
\arguments{
\item{p}{vector of p-values.}

\item{method}{multiplicity correction method, "gtxr" is the hybrid Hochberg-Hommel method, "quick" is the Quick method. Other methods include:"holm", "hochberg", "hommel", "bonferroni", "BH", "BY","fdr", "none" from the standard R function p.adjust.}

\item{n}{number of p-values.}
}
\value{
a vector of corrected p-values.
}
\description{
Given a set of p-values, returns adjusted p-values, including the hybrid Hochberg-Hommel procedure (Gou et al., 2014) and Quick procedure (Gou and Zhang, 2020).
}
\details{
Given a set of p-values, returns p-values adjusted using one of several methods. The default method is "gtxr". Another option is "quick". Other adjustment methods have been included in function p.adjust in R package stats.
}
\examples{
library(elitism)
 pvalues.raw <- c(0.002,0.007,0.005,0.024,0.022,0.009,0.007,0.036,0.060,0.035)
 p.adj.hoch <- elitism::p.adjust(pvalues.raw, method = "hochberg")
 p.adj.quick <- elitism::p.adjust(pvalues.raw, method = "quick")
 p.adj.gtxr <- elitism::p.adjust(pvalues.raw, method = "gtxr")
}
\references{
Gou, J., Tamhane, A. C., Xi, D., and Rom, D. (2014). A class of improved hybrid Hochberg-Hommel type step-up multiple test procedures. \emph{Biometrika} \bold{101}, 899-911. <https://dx.doi.org/10.1093/biomet/asu032>

Gou, J., and Zhang, F. (2020). Quick multiple test procedures and p-value adjustments. Technical report.
}
\seealso{
\code{stats::p.adjust}
}
\author{
Jiangtao Gou
}
