% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{check_dots_used}
\alias{check_dots_used}
\title{Check that all dots have been used}
\usage{
check_dots_used(env = parent.frame())
}
\arguments{
\item{env}{Environment in which to look for \code{...} and to set up handler.}
}
\description{
Automatically sets exit handler to run when function terminates, checking
that all elements of \code{...} have been evaluated.
}
\examples{
f <- function(...) {
  check_dots_used()
  g(...)
}

g <- function(x, y, ...) {
  x + y
}
f(x = 1, y = 2)

f(x = 1, y = 2, z = 3)
f(x = 1, y = 2, 3, 4, 5)
}
