% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat.R
\name{Chat}
\alias{Chat}
\title{A chat}
\value{
A Chat object
}
\description{
A \code{Chat} is a sequence of user and assistant \link{Turn}s sent
to a specific \link{Provider}. A \code{Chat} is a mutable R6 object that takes care of
managing the state associated with the chat; i.e. it records the messages
that you send to the server, and the messages that you receive back.
If you register a tool (i.e. an R function that the assistant can call on
your behalf), it also takes care of the tool loop.

You should generally not create this object yourself,
but instead call \code{\link[=chat_openai]{chat_openai()}} or friends instead.
}
\examples{
\dontshow{if (has_credentials("openai")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
chat <- chat_openai(echo = TRUE)
chat$chat("Tell me a funny joke")
\dontshow{\}) # examplesIf}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Chat-new}{\code{Chat$new()}}
\item \href{#method-Chat-get_turns}{\code{Chat$get_turns()}}
\item \href{#method-Chat-set_turns}{\code{Chat$set_turns()}}
\item \href{#method-Chat-add_turn}{\code{Chat$add_turn()}}
\item \href{#method-Chat-get_system_prompt}{\code{Chat$get_system_prompt()}}
\item \href{#method-Chat-get_model}{\code{Chat$get_model()}}
\item \href{#method-Chat-set_system_prompt}{\code{Chat$set_system_prompt()}}
\item \href{#method-Chat-get_tokens}{\code{Chat$get_tokens()}}
\item \href{#method-Chat-get_cost}{\code{Chat$get_cost()}}
\item \href{#method-Chat-last_turn}{\code{Chat$last_turn()}}
\item \href{#method-Chat-chat}{\code{Chat$chat()}}
\item \href{#method-Chat-chat_structured}{\code{Chat$chat_structured()}}
\item \href{#method-Chat-chat_structured_async}{\code{Chat$chat_structured_async()}}
\item \href{#method-Chat-chat_async}{\code{Chat$chat_async()}}
\item \href{#method-Chat-stream}{\code{Chat$stream()}}
\item \href{#method-Chat-stream_async}{\code{Chat$stream_async()}}
\item \href{#method-Chat-register_tool}{\code{Chat$register_tool()}}
\item \href{#method-Chat-get_provider}{\code{Chat$get_provider()}}
\item \href{#method-Chat-get_tools}{\code{Chat$get_tools()}}
\item \href{#method-Chat-set_tools}{\code{Chat$set_tools()}}
\item \href{#method-Chat-on_tool_request}{\code{Chat$on_tool_request()}}
\item \href{#method-Chat-on_tool_result}{\code{Chat$on_tool_result()}}
\item \href{#method-Chat-extract_data}{\code{Chat$extract_data()}}
\item \href{#method-Chat-extract_data_async}{\code{Chat$extract_data_async()}}
\item \href{#method-Chat-clone}{\code{Chat$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-new"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$new(provider, system_prompt = NULL, echo = "none")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{provider}}{A provider object.}

\item{\code{system_prompt}}{System prompt to start the conversation with.}

\item{\code{echo}}{One of the following options:
\itemize{
\item \code{none}: don't emit any output (default when running in a function).
\item \code{output}: echo text and tool-calling output as it streams in (default
when running at the console).
\item \code{all}: echo all input and output.
}

Note this only affects the \code{chat()} method.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-get_turns"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-get_turns}{}}}
\subsection{Method \code{get_turns()}}{
Retrieve the turns that have been sent and received so far
(optionally starting with the system prompt, if any).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$get_turns(include_system_prompt = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include_system_prompt}}{Whether to include the system prompt in the
turns (if any exists).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-set_turns"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-set_turns}{}}}
\subsection{Method \code{set_turns()}}{
Replace existing turns with a new list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$set_turns(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A list of \link{Turn}s.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-add_turn"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-add_turn}{}}}
\subsection{Method \code{add_turn()}}{
Add a pair of turns to the chat.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$add_turn(user, system)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{The user \link{Turn}.}

\item{\code{system}}{The system \link{Turn}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-get_system_prompt"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-get_system_prompt}{}}}
\subsection{Method \code{get_system_prompt()}}{
If set, the system prompt, it not, \code{NULL}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$get_system_prompt()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-get_model"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-get_model}{}}}
\subsection{Method \code{get_model()}}{
Retrieve the model name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$get_model()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-set_system_prompt"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-set_system_prompt}{}}}
\subsection{Method \code{set_system_prompt()}}{
Update the system prompt
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$set_system_prompt(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{A character vector giving the new system prompt}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-get_tokens"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-get_tokens}{}}}
\subsection{Method \code{get_tokens()}}{
A data frame with a \code{tokens} column that proides the
number of input tokens used by user turns and the number of
output tokens used by assistant turns.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$get_tokens(include_system_prompt = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include_system_prompt}}{Whether to include the system prompt in
the turns (if any exists).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-get_cost"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-get_cost}{}}}
\subsection{Method \code{get_cost()}}{
The cost of this chat
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$get_cost(include = c("all", "last"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include}}{The default, \code{"all"}, gives the total cumulative cost
of this chat. Alternatively, use \code{"last"} to get the cost of just the
most recent turn.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-last_turn"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-last_turn}{}}}
\subsection{Method \code{last_turn()}}{
The last turn returned by the assistant.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$last_turn(role = c("assistant", "user", "system"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{role}}{Optionally, specify a role to find the last turn with
for the role.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Either a \code{Turn} or \code{NULL}, if no turns with the specified
role have occurred.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-chat"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-chat}{}}}
\subsection{Method \code{chat()}}{
Submit input to the chatbot, and return the response as a
simple string (probably Markdown).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$chat(..., echo = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The input to send to the chatbot. Can be strings or images
(see \code{\link[=content_image_file]{content_image_file()}} and \code{\link[=content_image_url]{content_image_url()}}.}

\item{\code{echo}}{Whether to emit the response to stdout as it is received. If
\code{NULL}, then the value of \code{echo} set when the chat object was created
will be used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-chat_structured"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-chat_structured}{}}}
\subsection{Method \code{chat_structured()}}{
Extract structured data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$chat_structured(..., type, echo = "none", convert = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The input to send to the chatbot. Will typically include
the phrase "extract structured data".}

\item{\code{type}}{A type specification for the extracted data. Should be
created with a \code{\link[=type_boolean]{type_()}} function.}

\item{\code{echo}}{Whether to emit the response to stdout as it is received.
Set to "text" to stream JSON data as it's generated (not supported by
all providers).}

\item{\code{convert}}{Automatically convert from JSON lists to R data types
using the schema. For example, this will turn arrays of objects into
data frames and arrays of strings into a character vector.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-chat_structured_async"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-chat_structured_async}{}}}
\subsection{Method \code{chat_structured_async()}}{
Extract structured data, asynchronously. Returns a promise
that resolves to an object matching the type specification.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$chat_structured_async(..., type, echo = "none")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The input to send to the chatbot. Will typically include
the phrase "extract structured data".}

\item{\code{type}}{A type specification for the extracted data. Should be
created with a \code{\link[=type_boolean]{type_()}} function.}

\item{\code{echo}}{Whether to emit the response to stdout as it is received.
Set to "text" to stream JSON data as it's generated (not supported by
all providers).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-chat_async"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-chat_async}{}}}
\subsection{Method \code{chat_async()}}{
Submit input to the chatbot, and receive a promise that
resolves with the response all at once. Returns a promise that resolves
to a string (probably Markdown).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$chat_async(..., tool_mode = c("concurrent", "sequential"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The input to send to the chatbot. Can be strings or images.}

\item{\code{tool_mode}}{Whether tools should be invoked one-at-a-time
(\code{"sequential"}) or concurrently (\code{"concurrent"}). Sequential mode is
best for interactive applications, especially when a tool may involve
an interactive user interface. Concurrent mode is the default and is
best suited for automated scripts or non-interactive applications.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-stream"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-stream}{}}}
\subsection{Method \code{stream()}}{
Submit input to the chatbot, returning streaming results.
Returns A \href{https://coro.r-lib.org/articles/generator.html#iterating}{coro generator}
that yields strings. While iterating, the generator will block while
waiting for more content from the chatbot.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$stream(..., stream = c("text", "content"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The input to send to the chatbot. Can be strings or images.}

\item{\code{stream}}{Whether the stream should yield only \code{"text"} or ellmer's
rich content types. When \code{stream = "content"}, \code{stream()} yields
\link{Content} objects.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-stream_async"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-stream_async}{}}}
\subsection{Method \code{stream_async()}}{
Submit input to the chatbot, returning asynchronously
streaming results. Returns a \href{https://coro.r-lib.org/reference/async_generator.html}{coro async generator} that
yields string promises.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$stream_async(
  ...,
  tool_mode = c("concurrent", "sequential"),
  stream = c("text", "content")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{The input to send to the chatbot. Can be strings or images.}

\item{\code{tool_mode}}{Whether tools should be invoked one-at-a-time
(\code{"sequential"}) or concurrently (\code{"concurrent"}). Sequential mode is
best for interactive applications, especially when a tool may involve
an interactive user interface. Concurrent mode is the default and is
best suited for automated scripts or non-interactive applications.}

\item{\code{stream}}{Whether the stream should yield only \code{"text"} or ellmer's
rich content types. When \code{stream = "content"}, \code{stream()} yields
\link{Content} objects.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-register_tool"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-register_tool}{}}}
\subsection{Method \code{register_tool()}}{
Register a tool (an R function) that the chatbot can use.
If the chatbot decides to use the function, ellmer will automatically
call it and submit the results back.

The return value of the function. Generally, this should either be a
string, or a JSON-serializable value. If you must have more direct
control of the structure of the JSON that's returned, you can return a
JSON-serializable value wrapped in \code{\link[base:AsIs]{base::I()}}, which ellmer will leave
alone until the entire request is JSON-serialized.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$register_tool(tool_def)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tool_def}}{Tool definition created by \code{\link[=tool]{tool()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-get_provider"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-get_provider}{}}}
\subsection{Method \code{get_provider()}}{
Get the underlying provider object. For expert use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$get_provider()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-get_tools"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-get_tools}{}}}
\subsection{Method \code{get_tools()}}{
Retrieve the list of registered tools.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$get_tools()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-set_tools"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-set_tools}{}}}
\subsection{Method \code{set_tools()}}{
Sets the available tools. For expert use only; most users
should use \code{register_tool()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$set_tools(tools)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tools}}{A list of tool definitions created with \code{\link[=tool]{tool()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-on_tool_request"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-on_tool_request}{}}}
\subsection{Method \code{on_tool_request()}}{
Register a callback for a tool request event.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$on_tool_request(callback)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{callback}}{A function to be called when a tool request event occurs,
which must have \code{request} as its only argument.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A function that can be called to remove the callback.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-on_tool_result"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-on_tool_result}{}}}
\subsection{Method \code{on_tool_result()}}{
Register a callback for a tool result event.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$on_tool_result(callback)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{callback}}{A function to be called when a tool result event occurs,
which must have \code{result} as its only argument.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A function that can be called to remove the callback.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-extract_data"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-extract_data}{}}}
\subsection{Method \code{extract_data()}}{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Deprecated in favour of \verb{$chat_structured()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$extract_data(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See \verb{$chat_structured()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-extract_data_async"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-extract_data_async}{}}}
\subsection{Method \code{extract_data_async()}}{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$extract_data_async(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See \verb{$chat_structured_async()}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Chat-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Chat-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Chat$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
