% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content-image.R
\name{content_image_url}
\alias{content_image_url}
\alias{content_image_file}
\alias{content_image_plot}
\title{Encode images for chat input}
\usage{
content_image_url(url, detail = c("auto", "low", "high"))

content_image_file(path, content_type = "auto", resize = "low")

content_image_plot(width = 768, height = 768)
}
\arguments{
\item{url}{The URL of the image to include in the chat input. Can be a
\verb{data:} URL or a regular URL. Valid image types are PNG, JPEG, WebP, and
non-animated GIF.}

\item{detail}{The \href{https://platform.openai.com/docs/guides/images/image-input-requirements}{detail setting}
for this image. Can be \code{"auto"}, \code{"low"}, or \code{"high"}.}

\item{path}{The path to the image file to include in the chat input. Valid
file extensions are \code{.png}, \code{.jpeg}, \code{.jpg}, \code{.webp}, and (non-animated)
\code{.gif}.}

\item{content_type}{The content type of the image (e.g. \code{image/png}). If
\code{"auto"}, the content type is inferred from the file extension.}

\item{resize}{If \code{"low"}, resize images to fit within 512x512. If \code{"high"},
resize to fit within 2000x768 or 768x2000. (See the \href{https://platform.openai.com/docs/guides/images/image-input-requirements}{OpenAI docs}
for more on why these specific sizes are used.) If \code{"none"}, do not resize.

You can also pass a custom string to resize the image to a specific size,
e.g. \code{"200x200"} to resize to 200x200 pixels while preserving aspect ratio.
Append \code{>} to resize only if the image is larger than the specified size,
and \code{!} to ignore aspect ratio (e.g. \code{"300x200>!"}).

All values other than \code{none} require the \code{magick} package.}

\item{width, height}{Width and height in pixels.}
}
\value{
An input object suitable for including in the \code{...} parameter of
the \code{chat()}, \code{stream()}, \code{chat_async()}, or \code{stream_async()} methods.
}
\description{
These functions are used to prepare image URLs and files for input to the
chatbot. The \code{content_image_url()} function is used to provide a URL to an
image, while \code{content_image_file()} is used to provide the image data itself.
}
\examples{
\dontshow{ellmer:::vcr_example_start("content_image_url")}
chat <- chat_openai()
chat$chat(
  "What do you see in these images?",
  content_image_url("https://www.r-project.org/Rlogo.png"),
  content_image_file(system.file("httr2.png", package = "ellmer"))
)

\dontrun{
plot(waiting ~ eruptions, data = faithful)
chat <- chat_openai()
chat$chat(
  "Describe this plot in one paragraph, as suitable for inclusion in
   alt-text. You should briefly describe the plot type, the axes, and
   2-5 major visual patterns.",
   content_image_plot()
)
}
\dontshow{ellmer:::vcr_example_end()}
}
