% Generated by roxygen2 (4.0.2): do not edit by hand
\name{tsd_MHmcmc_p}
\alias{tsd_MHmcmc_p}
\title{Generates set of parameters to be used with tsd_MHmcmc()}
\usage{
tsd_MHmcmc_p(result = stop("An output from tsd() must be provided"),
  accept = FALSE)
}
\arguments{
\item{result}{An object obtained after a tsd fit}

\item{accept}{If TRUE, the script does not wait user information}
}
\value{
A matrix with the parameters
}
\description{
Interactive script used to generate set of parameters to be
used with tsd_MHmcmc().\cr
}
\details{
tsd_MHmcmc_p generates set of parameters to be used with embryogrowth_MHmcmc()
}
\examples{
\dontrun{
library(embryogrowth)
eo <- subset(STSRE_TSD, Species=="Emys orbicularis", c("Males", "Females",
                                       "Incubation.temperature"))
eo_logistic <- with(eo, tsd(males=Males, females=Females,
                                 temperatures=Incubation.temperature))
pMCMC <- tsd_MHmcmc_p(eo_logistic, accept=TRUE)
}
}
\author{
Marc Girondot
}

