% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot_transition.R
\name{plot_transition}
\alias{plot_transition}
\title{Show fonction used for transition}
\usage{
plot_transition(result = NULL, parameters = NULL, sizes = c(0, 40), ...)
}
\arguments{
\item{result}{A result object}

\item{parameters}{Set of parameters. If both result and parameters are indicated, parameters have priority.}

\item{sizes}{The range of possible sizes}

\item{...}{Parameters for plot() such as main= or ylim=}
}
\value{
Nothing
}
\description{
Plot the transition function
}
\details{
plot_transition show fonction used for transition
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
data(resultNest_4p)
# Get a set of parameters without transition
x1 <- resultNest_4p$par
# Generate a set of parameters with transition
x2 <- switch.transition(x1)
x2 <- x2[names(x2)!="transition_P"]
x2["transition_S"] <- 4
pfixed <- c(rK=2.093313, transition_P=20)
resultNest_4p_transition <- searchR(parameters=x2, fixed.parameters=pfixed,
temperatures=formated, derivate=dydt.Gompertz, M0=1.7,
test=c(Mean=39.33, SD=1.92))
data(resultNest_4p_transition)
# show the model for smallest size
plotR(resultNest_4p_transition, ylim=c(0,0.3))
# show the model for larger sizes
plotR(resultNest_4p_transition, set.par=2, ylim=c(0,0.3))
# plot model for both together
plotR(resultNest_4p_transition, set.par=c(1,2), ylim=c(0,0.3),
       col=c("red", "black"), legend=list("Initial", "End"))
plot_transition(result=resultNest_4p_transition, las=1, sizes=c(0,40))
compare_AIC(one.model=list(resultNest_4p), two.models=list(resultNest_4p_transition))
# Note that the model with fitted transition_P is trivial. Embryos grow fast until
# they reach hatchling size and then growth rate becomes null!
}
}
\author{
Marc Girondot
}

