#' Result of the mcmc using the nest database using trigonometric function
#' @title Result of the fit using the nest database using trigonometric function
#' @author Marc Girondot \email{marc.girondot@@u-psud.fr}
#' @docType data
#' @name resultNest_mcmc_4p_trigo
#' @encoding UTF-8
#' @description Fit using the nest database using trigonometric function
#' @references Girondot, M., & Kaska, Y. (2014). A model to predict 
#'             the thermal reaction norm for the embryo growth rate 
#'             from field data. Journal of Thermal Biology, 45, 96-102. 
#'             doi: 10.1016/j.jtherbio.2014.08.005
#' @keywords datasets
#' @usage resultNest_mcmc_4p_trigo
#' @examples
#' \dontrun{
#' library(embryogrowth)
#' data(nest)
#' formated <- FormatNests(nest)
#' x <- ChangeSSM(temperatures = (200:350)/10,
#'                parameters = resultNest_4p_SSM4p$par,
#'                initial.parameters = structure(c(3, 20, 40, 32), 
#'                          .Names = c("Max", "LengthB", "LengthE", "Peak")), 
#'                control=list(maxit=1000))
#' pfixed <- c(rK=2.093313)
#' resultNest_4p_trigo <- searchR(parameters=x$par, fixed.parameters=pfixed, 
#'                          temperatures=formated, derivate=dydt.Gompertz, M0=1.7, 
#'                          test=c(Mean=39.33, SD=1.92))
#' plotR(resultNest_4p_trigo, ylim=c(0, 3))
#' compare_AIC(SSM=resultNest_4p_SSM4p, trigo=resultNest_4p_trigo)
#' pMCMC <- TRN_MHmcmc_p(resultNest_4p_trigo, accept = TRUE)
#' resultNest_mcmc_4p_trigo <- GRTRN_MHmcmc(result = resultNest_4p_trigo, 
#'          n.iter = 50000, parametersMCMC = pMCMC, 
#'          adaptive = TRUE,
#'          intermediate = 1000, filename = "intermediate_mcmc.Rdata")
#' 1-rejectionRate(as.mcmc(resultNest_mcmc_4p_trigo))
#' as.parameters(resultNest_mcmc_4p_trigo)
#' layout(mat=matrix(1:4, nrow = 2))
#' plot(resultNest_mcmc_4p_trigo, parameters = "all", scale.prior = TRUE, las = 1)
#' layout(mat=1)
#' plotR(resultNest_4p_trigo, resultmcmc=resultNest_mcmc_4p_trigo, ylim=c(0,4), 
#'        main="Trigonometric function", show.density=TRUE)
#' }
#' @format A list with fitted information about data(nest)
NULL
