% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoji.R
\name{emoji}
\alias{emoji}
\title{Find a single emoji}
\usage{
emoji(keyword)
}
\arguments{
\item{keyword}{Character, either name or keyword. If more than one emoji has
the specified keyword, will pick one at random.}
}
\description{
This function starts by looking for exact matches in \code{emoji_name}. If none is
found in \code{emoji_name} then it looks in \code{emoji_keyword}. \code{emoji_keyword} can
produce more then 1 matches, which will lead to one being returned at random.
}
\details{
This function isn't vectorized and will thus only work with 1 keyword at a
time.
}
\examples{
emoji("smile")
emoji("taco")

set.seed(1234)
replicate(24, emoji("clock"))
replicate(10, emoji("flag"))
}
