% Generated by roxygen2 (4.0.2): do not edit by hand
\name{enigma_fetch}
\alias{enigma_fetch}
\alias{enigma_read}
\title{Download a gzipped csv file of a dataset.}
\usage{
enigma_fetch(dataset = NULL, path = NULL, overwrite = TRUE, key = NULL,
  ...)

enigma_read(input)
}
\arguments{
\item{dataset}{Dataset name. Required.}

\item{path}{File name and path of output zip file. Defaults to write a zip file to your home
directory with name of the dataset, and file extension \code{.csv.gz}.}

\item{overwrite}{Will only overwrite existing path if TRUE.}

\item{key}{(character) Required. An Enigma API key. Supply in the function call, or store in
your \code{.Rprofile} file, or do \code{options(enigmaKey = "<your key>")}. Obtain an API key
by creating an account with Enigma at \url{http://enigma.io}, then obtain an API key from
your account page.}

\item{...}{Named options passed on to \code{\link[httr]{GET}}}

\item{input}{The output from \code{enigma_fetch} or a path to a file downloaded from Enigma.io}
}
\description{
Download a gzipped csv file of a dataset.
}
\details{
Note that \code{\link[enigma]{enigma_fetch}} downloads the file, and gives back a
path to the file. In a separte function, \code{\link[enigma]{enigma_read}}, you can read in the
data. \code{\link[enigma]{enigma_fetch}} doesn't read in data in case the file is very large
which may make your R session crash or slow down significantly.
}
\examples{
\dontrun{
# After obtaining an API key from Enigma's website, pass in your key to the function call
# or set in your options (see above instructions for the key parameter)
# If you pass in your key to the function call use the key parameter

# Fetch the Crunchbase companies info dataset
res <- enigma_fetch(dataset='com.crunchbase.info.companies.acquisition')
enigma_read(res)

# Piping workflow
library('dplyr')
enigma_fetch(dataset='com.crunchbase.info.companies.acquisition') \%>\%
   enigma_read \%>\%
   glimpse

# Curl debugging
library('httr')
enigma_fetch(dataset='com.crunchbase.info.companies.acquisition', config=verbose())
}
}

