% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longLatRasts.r
\name{longLatRasts}
\alias{longLatRasts}
\title{Generate rasters with cell values equal to cell longitude or latitude}
\usage{
longLatRasts(x, m = TRUE, filePath = NULL, ...)
}
\arguments{
\item{x}{\code{SpatRaster} object. The output will have the same resolution, extent, and coordinate projection system as \code{x}.}

\item{m}{Any of:
\itemize{
    \item \code{TRUE} (default): Calculate longitude and latitude only for cells that are not \code{NA}.
    \item \code{FALSE}: Calculate longitude and latitude for all cells.
    \item A \code{SpatRaster} object: Force any cells that are \code{NA} in this raster to also be \code{NA} in the output.
}}

\item{filePath}{String or \code{NULL}. If a string, then this is the path (not including file name) to which to write the raster stack with longitude/latitude rasters. If \code{NULL} then no file is written.}

\item{...}{Arguments to pass to \code{writeRaster} (if \code{filePath} is not \code{NULL}).}
}
\value{
Object of class \code{SpatRaster}.
}
\description{
This function generates a raster stack with two rasters, one with cell values equal to the cell's longitude and the other with cell values equal to the cell's latitude.
}
\examples{

library(terra)

# generate long/lat rasters for the world
x <- rast() # raster with 1 deg resolution and extent equal to entire world
x[] <- 1:ncell(x)
longLat <- longLatRasts(x)
plot(longLat)

# demonstrate masking
# randomly force some cells to NA
v <- 1:ncell(x)
n <- 10000
v[sample(v, n)] <- NA
x[] <- v
longLatTRUE <- longLatRasts(x, m = TRUE)
longLatFALSE <- longLatRasts(x, m = FALSE)
rasts <- c(x, longLatTRUE, x, longLatFALSE)
names(rasts) <- c('x', 'long_m_TRUE', 'lat_m_TRUE',
	'x', 'long_m_FALSE', 'lat_m_FALSE')
plot(rasts)

}
