% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customCRS.r
\name{customAlbers}
\alias{customAlbers}
\alias{customLambert}
\alias{customVNS}
\title{Custom coordinate reference system WKT2 string}
\usage{
customAlbers(x)

customLambert(x)

customVNS(x, alt = 35800)
}
\arguments{
\item{x}{Either an object of class \code{SpatRaster}, \code{SpatVector}, or \code{sf}, \emph{or} a numeric vector with two values (longitude and latitude of the center of the projection), \emph{or} a two-column matrix/data frame with the centroid of the projection.}

\item{alt}{Altitude in meters of the viewpoint in km. The default (35800 km) is geosynchronous orbit.}
}
\value{
A WKT2 (well-known text) string.
}
\description{
These functions take as input either a spatial object or coordinate pair and a custom WKT2 (well-known text) coordinate reference system string centered on the object or coordinate. Projections include:
\itemize{
\item Albers conic equal-area
\item Lambert azimuthal equal-area
\item Vertical near-side (i.e., as the world appears from geosynchronous orbit)
}
Please note that these are \emph{NOT} standard projections, so do not have an EPSG or like code.
}
\section{Functions}{
\itemize{
\item \code{customLambert()}: Custom coordinate reference system WKT2 string

\item \code{customVNS()}: Custom coordinate reference system WKT2 string

}}
\examples{
library(sf)

# Madagascar
data(mad0)

alb <- customAlbers(mad0)
lamb <- customLambert(mad0)
vert <- customVNS(mad0)

madAlb <- st_transform(mad0, alb)
madLamb <- st_transform(mad0, lamb)
madVert <- st_transform(mad0, vert)

oldPar <- par(mfrow=c(2, 2))

plot(st_geometry(mad0), main='Unprojected (WGS84)')
plot(st_geometry(madAlb), main='Albers')
plot(st_geometry(madLamb), main='Lambert')
plot(st_geometry(madVert), main='Vertical')

par(oldPar)

\donttest{
# The effect is more noticeable when plotting large areas,
# especially if they lie near the poles.
# This example can take a few minutes to run and plot.

library(geodata)
library(terra)

# Get outline of Canada...
# We wrap this in tryCatch() in case the server is down.
can <- tryCatch(
	gadm('CAN', level=0, path=tempdir(), resolution=2),
	error=function(cond) FALSE
)

if (!is.logical(can)) {

	alb <- customAlbers(can)
	lamb <- customLambert(can)
	vert <- customVNS(can)

	canAlb <- project(can, alb)
	canLamb <- project(can, lamb)
	canVert <- project(can, vert)

	oldPar <- par(mfrow=c(2, 2))

	plot(can, main='Unprojected (WGS84)')
	plot(canAlb, main='Albers')
	plot(canLamb, main='Lambert')
	plot(canVert, main='Vertical')
		
	par(oldPar)
	
}		

}
}
\seealso{
\code{\link{getCRS}}, \code{\link{customAlbers}}, \code{\link{customLambert}}, \code{\link{customVNS}}
}
