% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{KRDetect.outliers.plot}
\alias{KRDetect.outliers.plot}
\title{Outlier detection plot}
\usage{
KRDetect.outliers.plot(x, segments = TRUE, all = TRUE)
}
\arguments{
\item{x}{a list obtained as an output of function \code{\link{KRDetect.outliers.changepoint}}, \code{\link{KRDetect.outliers.controlchart}} or \code{\link{KRDetect.outliers.EV}} for identification of outliers.}

\item{segments}{a logical variable specifying if vertical lines representing individual segments are plotted. Only required for results obtained using \code{\link{KRDetect.outliers.changepoint}} function. Default is \code{segments = TRUE}.}

\item{all}{a logical variable.
Only required for results obtained using functions \code{\link{KRDetect.outliers.controlchart}} and \code{\link{KRDetect.outliers.EV}}. Default is \code{all = TRUE}.
In case of results obtained using function \code{\link{KRDetect.outliers.controlchart}} specifying if individual graphs for outliers detected using control chart x, R and s are plotted together with graph visualising outliers detected based on at least 1 control chart.
If \code{all = FALSE}, only one graph visualising outliers detected based on at least 1 control chart is plotted.
In case of results obtained using function \code{\link{KRDetect.outliers.EV}} specifying if individual graphs for outliers with extremely low and extremely high value are plotted together with graph visualising outliers with both extremely low and extremely high value.
If \code{all = FALSE}, only one graph visualising outliers with both extremely low and extremely high value is plotted.}
}
\description{
Plot of results obtained using functions \code{\link{KRDetect.outliers.changepoint}}, \code{\link{KRDetect.outliers.controlchart}} and \code{\link{KRDetect.outliers.EV}} for identification of outliers.
The function graphically visualizes results obtained using functions for outlier detection implemented in package \pkg{envoutliers}.
}
\details{
This function plots the results obtained using function \code{\link{KRDetect.outliers.changepoint}}, \code{\link{KRDetect.outliers.controlchart}} or \code{\link{KRDetect.outliers.EV}} implemented in package \pkg{envoutliers} and identificating outliers.
}
\examples{
data("mydata", package = "openair")
x = mydata$o3[format(mydata$date, "\%m \%Y") == "12 2002"]
result = KRDetect.outliers.EV(x)
KRDetect.outliers.plot(result)
}
