% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint.R
\name{normal.distr.quantiles.detect}
\alias{normal.distr.quantiles.detect}
\title{Normal distribution based identification of outliers on segments - Only intended for developer use}
\usage{
normal.distr.quantiles.detect(x, cp.segment, alpha.default)
}
\arguments{
\item{x}{a numeric vector of data.}

\item{cp.segment}{an integer membership vector for individual segments.}

\item{alpha.default}{a numeric value from interval (0,1) of alpha parameter determining the criterion for outlier detection:
the limits for outlier observations on individual segments are set as \emph{+/- (alpha/2-quantile of normal distribution with parameters corresponding to data on studied segment) * (sample standard deviation of data on corresponding segment)}
If \code{alpha.default = NULL}, its value on individual segments is estimated using Modified Algorithm A1 (Campulova et al., 2018).}
}
\value{
A list is returned with elements:
\item{alpha}{a numeric vector of alpha parameters used for outlier identification on individual segments}
\item{outlier}{a logical vector specyfing the identified outliers, \code{TRUE} means that corresponding data value from vector \code{x} is detected as an outlier}
}
\description{
Identification of outlier data values on individual homogeneous segments using quantiles of normal distribution.
The function is called by \code{\link{KRDetect.outliers.changepoint}} and is not intended for use by regular users of the package.
}
\details{
This function detects outlier observations on individual segments using quantiles of normal distribution.
The function is exported for developer use only. It does not perform any checks on inputs since it is only convenience function for identification of outlier residuals.
}
\references{
Campulova M, Michalek J, Mikuska P, Bokal D (2018). Nonparametric algorithm for identification of outliers in environmental data. Journal of Chemometrics, 32, 453-463.
}
