% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endemic_channel.R
\name{endemic_channel}
\alias{endemic_channel}
\title{Create and return the endemic channel of a disease from an incidence object}
\usage{
endemic_channel(
  incidence_historic,
  observations = NULL,
  method = c("geometric", "median", "mean", "unusual_behavior"),
  geometric_method = "shifted",
  outlier_years = NULL,
  outliers_handling = c("ignored", "included", "replaced_by_median", "replaced_by_mean",
    "replaced_by_geometric_mean"),
  ci = 0.95,
  plot = FALSE,
  language = c("EN", "ES")
)
}
\arguments{
\item{incidence_historic}{An incidence object with the historic weekly
observations}

\item{observations}{A numeric vector with the current observations}

\item{method}{A string with the mean calculation method of preference
(median, mean, or geometric) or to use the unusual behavior method (Poisson
Distribution Test for Hypoendemic settings)}

\item{geometric_method}{A string with the selected method for geometric mean
calculation; see: geometric_mean}

\item{outlier_years}{A numeric vector with the outlier years}

\item{outliers_handling}{A string with the handling decision regarding
outlier years, see: outliers_handling function}

\item{ci}{= 0.95 A numeric value to specify the confidence interval to use
with the geometric method}

\item{plot}{A boolean for displaying a plot}

\item{language}{Language for plot components}
}
\value{
A dataframe with the observation, historical mean, and confidence
intervals (or risk areas)
}
\description{
Function that builds the endemic channel of a disease time
series based on the selected method and windows of observation
}
\examples{
data_event <- epiCo::epi_data
data_ibague <- data_event[data_event$cod_mun_o == 73001, ]
incidence_historic <- incidence::incidence(data_ibague$fec_not,
  interval = "1 epiweek"
)
endemic_channel(incidence_historic,
  method = "geometric", plot = TRUE
)
}
