% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.igraph.epicontacts.R
\name{as.igraph.epicontacts}
\alias{as.igraph.epicontacts}
\title{Create igraph object from contact data}
\usage{
\method{as.igraph}{epicontacts}(x)
}
\arguments{
\item{x}{An \code{\link{epicontacts}} object.}
}
\value{
An \code{igraph} object (from the \code{igraph} package).  Note: any
  column called "name" in the original linelist will be stored as a new
  vertex attribute in the \code{igraph} object named 'epicontacts_name'.
  This is due to the inherent behaviour of igraph creating its own 'name'
  vertex attribute.
}
\description{
This function creates an igraph object from a given \code{\link{epicontacts}}
object containing a 'contacts' dataframe.
}
\examples{

if (require(outbreaks) && require(igraph)) {
## build data

x <- make_epicontacts(ebola_sim$linelist, ebola_sim$contacts,
                      id = "case_id", to = "case_id", from ="infector",
                      directed = TRUE)


## subset data - keep 50 cases from linelist with contacts

ids <- get_id(x, "common")[1:50]
ids
x <- x[ids, ids]


## make igraph object with associated attributes from epicontacts object

net <- as.igraph(x)
net
plot(net, vertex.label = "", vertex.size = 10,
     vertex.color = cases_pal(50))
}
}
\author{
Nistara Randhawa (\email{nrandhawa@ucdavis.edu})
}
