% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfuncs.R
\name{chainSIR}
\alias{chainSIR}
\title{Gradient-function for the chain-SIR model}
\usage{
chainSIR(t, logx, params)
}
\arguments{
\item{t}{Implicit argument for time}

\item{logx}{A vector with values for the log-states}

\item{params}{A vector with parameter values for the chain-SIR system}
}
\value{
A list of gradients
}
\description{
Gradient-function for the chain-SIR model
}
\examples{
require(deSolve)
times  = seq(0, 10, by=1/52)
paras2  = c(mu = 1/75, N = 1, beta =  625, gamma = 365/14, u=5)
xstart2 = log(c(S=.06, I=c(0.001, rep(0.0001, paras2["u"]-1)), R = 0.0001))
out = as.data.frame(ode(xstart2, times, chainSIR, paras2))
}
