% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sir.R
\name{sirAgemod}
\alias{sirAgemod}
\title{Gradient-function for the age-structured SIR model with possibly heterogeneous mixing}
\usage{
sirAgemod(t, logx, parameters)
}
\arguments{
\item{t}{Implicit argument for time}

\item{logx}{A vector with initial values for the log-states}

\item{parameters}{A named list with parameter values for the age-structured SIR system. N is population size, gamma is recovery rate, mu is birth/death rate, beta is transmission rate, W is the normalized contact matrix, v is vector of age-class specific vaccination rates and r is class-specific aging rates (since age brackets may differ in width).}
}
\value{
A list of gradients
}
\description{
Gradient-function for the age-structured SIR model with possibly heterogeneous mixing
}
\examples{
ra=rep(1,4)
n=length(ra)
W=matrix(1, ncol=4, nrow=4)
paras =list(N=1, gamma=365/14, mu=0.02, beta=500, W=W,v=rep(0,4), r=ra)
xstart=log(c(S=rep(0.099/n,n), I=rep(0.001/n,n), R=rep(0.9/n,n)))
times=seq(0,10,by=14/365)
out=as.data.frame(ode(xstart, times, sirAgemod, paras))
}
