% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsir.R
\name{tsirSim}
\alias{tsirSim}
\title{Function to simulate the stochastic TSIR}
\usage{
tsirSim(
  alpha = 0.97,
  B = 2300,
  beta = 25,
  sdbeta = 0,
  S0 = 0.06,
  I0 = 180,
  IT = 520,
  N = 3300000
)
}
\arguments{
\item{alpha}{the exponent on I}

\item{B}{the birth rate}

\item{beta}{the transmission rate}

\item{sdbeta}{the standard deviation on beta}

\item{S0}{the initial susceptible fraction}

\item{I0}{the initial number of infected}

\item{IT}{the length of simulation}

\item{N}{the population size}
}
\value{
A list with time series of simulated infected and susceptible hosts
}
\description{
Function to simulate the stochastic TSIR assuming stochasticity in transmission and a Poisson birth-death process
}
\examples{
out = tsirSim()
}
