% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twostrain.r
\name{twostrain}
\alias{twostrain}
\title{Gradient-function for the two-strain SIR model}
\usage{
twostrain(t, y, parameters)
}
\arguments{
\item{t}{Implicit argument for time}

\item{y}{A vector with initial values for the states}

\item{parameters}{A vector with parameter values for the two-strain SIR  system}
}
\value{
A list of gradients
}
\description{
Gradient-function for the two-strain SIR model
}
\examples{
require(deSolve)
times  = seq(0, 30, by=1/200)
paras  = c(mu = 0.02, N = 1, beta1=500, beta2=750, gamma = 365/5, Theta=0.15, Xi=0.15, Pi=0.8)
start = c(S = 0.999, I1 = 0.001, I2 = 0.00, R1=0, R2=0, J1=0, J2=0, R = 0)
out = as.data.frame(ode(start, times, twostrain, paras))
}
