% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_params.R
\name{convert_summary_stats_to_params}
\alias{convert_summary_stats_to_params}
\alias{convert_summary_stats_to_params.character}
\alias{convert_summary_stats_to_params.epiparameter}
\title{Convert the summary statistics of a distribution to parameters}
\usage{
convert_summary_stats_to_params(x, ...)

\method{convert_summary_stats_to_params}{character}(
  x = c("lnorm", "gamma", "weibull", "nbinom", "geom"),
  ...
)

\method{convert_summary_stats_to_params}{epiparameter}(x, ...)
}
\arguments{
\item{x}{An \R object.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> \code{Numeric} named summary
statistics used to convert to parameter(s). An example is the \code{mean}
and \code{sd} summary statistics for the lognormal (\code{lnorm}) distribution.}
}
\value{
A list of either one or two elements (depending on how many
parameters the distribution has).
}
\description{
Convert the summary statistics for a range of distributions to
the distribution's parameters. Most summary statistics are calculated
analytically given the parameters. An exception is the Weibull distribution
which uses a root finding numerical method.
}
\details{
Summary statistics should be named accordingly (case-sensitive):
\itemize{
\item mean: \code{mean}
\item median: \code{median}
\item mode: \code{mode}
\item variance: \code{var}
\item standard deviation: \code{sd}
\item coefficient of variation: \code{cv}
\item skewness: \code{skewness}
\item excess kurtosis: \code{ex_kurtosis}
}

\strong{Note}: Not all combinations of summary statistics can be converted into
distribution parameters. In this case the function will error stating that
the parameters cannot be calculated from the given input.

The distribution names and parameter names follow the style of
distributions in \R, for example the lognormal distribution is \code{lnorm},
and its parameters are \code{meanlog} and \code{sdlog}.
}
\examples{
# examples using characters
convert_summary_stats_to_params("lnorm", mean = 1, sd = 1)
convert_summary_stats_to_params("weibull", mean = 2, var = 2)
convert_summary_stats_to_params("geom", mean = 2)

# examples using <epiparameter>
epiparameter <- epiparameter_db(single_epiparameter = TRUE)
convert_summary_stats_to_params(epiparameter)

# example using <epiparameter> and specifying summary stats
epiparameter$summary_stats <- list()
convert_summary_stats_to_params(epiparameter, mean = 10, sd = 2)
}
\seealso{
\code{\link[=convert_params_to_summary_stats]{convert_params_to_summary_stats()}}
}
