% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{indAndSub}
\alias{indAndSub}
\alias{ind2sub}
\alias{sub2ind}
\title{Retrieve vector or array indices}
\usage{
ind2sub(ind, .dim, .dimnames = NULL, useNames = FALSE)

sub2ind(sub, .dim)
}
\arguments{
\item{ind}{Vector indices.}

\item{.dim}{\code{\link{dim}(.)} integer vector}

\item{.dimnames}{optional list of character \code{\link{dimnames}(.)}.
   If \code{useNames} is true, to be used for constructing dimnames for
   \code{arrayInd()} (and hence, \code{which(*, arr.ind=TRUE)}).
   If \code{\link{names}(.dimnames)} is not empty, these are used as
   column names.  \code{.dimnames[[1]]} is used as row names.}

\item{useNames}{logical indicating if the value of \code{arrayInd()}
   should have (non-null) dimnames at all.}

\item{sub}{Array/matrix indices.}
}
\description{
\code{ind2sub} is a synonym for \code{\link[base]{arrayInd}} in \code{base} package.
}
\details{
\code{ind2sub} is just an alias for \code{\link[base]{arrayInd}}
}
\examples{
set.seed(12345)
mat <- matrix(round(runif(6, min = 0, max = 10)), nrow = 2, ncol = 3)
ind2sub(4, dim(mat))
sub2ind(c(2, 2), dim(mat))
subs <- as.matrix(expand.grid(1:2,2:3))
sub2ind(subs, dim(mat))

}
\keyword{internal}
