% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate.R
\name{rate}
\alias{rate}
\title{Calculate risk ratio and risk difference}
\usage{
rate(data, outcome, denominator, exposure, per_unit, ci_level = 95)
}
\arguments{
\item{data}{A dataframe}

\item{outcome}{Variable with the outcomes as a numeric variable}

\item{denominator}{Variable giving the amount of time at risk}

\item{exposure}{Variable giving whether exposed or not}

\item{per_unit}{Multiplier for rate values, e.g. \code{1000} for n outcomes per 1000 denominator}

\item{ci_level}{A numeric value giving the confidence interval}
}
\description{
Calculate risk ratios and risk differences using a Poisson distribution for
person-time data.
Function works on individual level data or aggregated data
p244 2nd Edition
}
\examples{

# Using individual level data

data(ebola)
library(dplyr)
ebola \%>\%
 mutate(male = ifelse(sex == "male", 1, 0)) \%>\%
  rate(outcome = died, denominator = days_at_risk, exposure = male,
  per_unit = 100)

# Using aggregated data
# Table 14-2
cancer_xray <- data.frame(cases = c(41, 15), pyar = c(28010, 19017),
radiation = c(1, 0))
cancer_xray
cancer_xray \%>\%
  rate(outcome = cases, denominator = pyar, exposure = radiation,
    per = 100000)
}
