% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataviz.R
\name{trend_line}
\alias{trend_line}
\title{Plot the trendline report of epitweetr dashboard}
\usage{
trend_line(
  topic,
  countries = c(1),
  date_type = "created_date",
  date_min = "1900-01-01",
  date_max = "2100-01-01",
  with_retweets = FALSE,
  location_type = "tweet",
  alpha = 0.025,
  alpha_outlier = 0.05,
  k_decay = 4,
  no_historic = 7,
  bonferroni_correction = FALSE,
  same_weekday_baseline = FALSE
)
}
\arguments{
\item{topic}{Character(1) containing the topic to use for the report}

\item{countries}{Character vector containing the name of the countries and regions to plot or their respective indexes on the Shiny app select, default: c(1)}

\item{date_type}{Character vector specifying the time granularity of the report either 'created_weeknum' or 'created_date', default: 'created_date'}

\item{date_min}{Date indicating start of the reporting period, default: "1900-01-01"}

\item{date_max}{Date indicating end of the reporting period, default: "2100-01-01"}

\item{with_retweets}{Logical value indicating whether to include retweets in the time series, default: FALSE}

\item{location_type}{Character(1) vector indicating the location type. Possible values 'tweet', 'user' or 'both', default: 'tweet'}

\item{alpha}{Numeric(1) value indicating the alert detection confidence, default: 0.025}

\item{alpha_outlier}{Numeric(1) value indicating the outliers detection confidence for downweighting, default: 0.05}

\item{k_decay}{Strength of outliers downweighting, default: 4}

\item{no_historic}{Number of observations to build the baseline for signal detection, default: 7}

\item{bonferroni_correction}{Logical value indicating whether to apply the Bonferroni correction for signal detection, default: FALSE}

\item{same_weekday_baseline}{Logical value indicating whether to use same day of weeks for building the baseline or consecutive days, default: FALSE}
}
\value{
A named list containing two elements: 'chart' with the ggplot2 figure and 'data' containing the dataframe that was used to build the chart.
}
\description{
Generates a trendline chart of number of tweets by region, for one topic, including alerts using the reweighted version of the EARS algorithm
}
\details{
Produces a multi-region line chart for a particular topic of number of tweets collected based on the provided parameters. 
Alerts will be calculated using a modified version of the EARS algorithm that applies a Farrington inspired downweighting of previous outliers.

Days in this function are considered as contiguous blocks of 24 hours starting for the previous hour of the last collected tweet.

This function requires \code{\link{search_loop}} and \code{\link{detect_loop}} to have already run successfully to show results.
}
\examples{
if(FALSE){
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())
   #Getting trendline for dengue for South America for the last 30 days
   trend_line(
     topic = "dengue", 
     countries = "South America", 
     date_min = as.Date(Sys.time())-30, 
     date_max=as.Date(Sys.time())
   ) 
}
}
\seealso{
\code{\link{create_map}}
 \code{\link{create_topwords}}
 \code{\link{generate_alerts}}
 \code{\link{aggregate_tweets}}
 \code{\link{geotag_tweets}}
 \code{\link{detect_loop}}
 \code{\link{search_loop}}
}
