% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{setup_config}
\alias{setup_config}
\title{Load epitweetr application settings}
\usage{
setup_config(
  data_dir = if (exists("data_dir", where = conf)) conf$data_dir else if
    (Sys.getenv("EPI_HOME") != "") Sys.getenv("EPI_HOME") else file.path(getwd(),
    "epitweetr"),
  ignore_keyring = FALSE,
  ignore_properties = FALSE,
  ignore_topics = FALSE,
  save_first = list()
)
}
\arguments{
\item{data_dir}{Path to the directory containing the application settings (it must exist). 
If not provided it takes the value of the latest call to setup_config in the current session, or the value of the EPI_HOME environment variable or epitweetr subdirectory in the working directory, 
default: if (exists("data_dir", where = conf)) conf$data_dir else if (Sys.getenv("EPI_HOME") !=
   "") Sys.getenv("EPI_HOME") else file.path(getwd(), "epitweetr")}

\item{ignore_keyring}{Whether to skip loading settings from the keyring (Twitter and SMTP credentials), default: FALSE}

\item{ignore_properties}{Whether to skip loading settings managed by the Shiny app in properties.json file, Default: FALSE}

\item{ignore_topics}{Whether to skip loading settings defined in the topics.xlsx file and download plans from topics.json file, default: FALSE}

\item{save_first}{Whether to save current settings before loading new ones from disk, default: list()}
}
\value{
Nothing
}
\description{
Load epitweetr application settings from the designated data directory
}
\details{
epitweetr relies on settings and data stored in a system folder, so before loading the dashboard, collecting tweets or detecting alerts the user has to designate this folder.
When a user wants to use epitweetr from the R console they will need to call this function for initialisation.
The 'data_folder' can also be given as a parameter for program launch functions \code{\link{epitweetr_app}}, \code{\link{search_loop}} or \code{\link{detect_loop}}, which will internally call this function.

This call will fill (or refresh) a package scoped environment 'conf' that will store the settings. Settings stored in conf are:
\itemize{
  \item{General properties of the Shiny app (stored in properties.json)}
  \item{Download plans from the Twitter collection process (stored in topics.json merged with data from the topics.xlsx file}
  \item{Credentials for Twitter API and SMTP stored in the defined keyring}
}

When calling this function and the keyring is locked, a password will be prompted to unlock the keyring.
This behaviour can be changed by setting the environment variable 'ecdc_twitter_tool_kr_password' with the password.

Changes made to conf can be stored permanently (except for 'data_dir') using:
\itemize{
  \item{\code{\link{save_config}}, or}
   \item{\code{\link{set_twitter_app_auth}}}
}
}
\examples{
if(FALSE){
   library(epitweetr)
   #loading system settings
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())
}
}
\seealso{
\code{\link{save_config}}
\code{\link{set_twitter_app_auth}}
\code{\link{epitweetr_app}}
\code{\link{search_loop}}
\code{\link{detect_loop}}
}
