% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{epiworld-transition}
\alias{epiworld-transition}
\alias{epiworld_hist_transition}
\alias{get_hist_transition_matrix}
\alias{as.array.epiworld_hist_transition}
\alias{plot_incidence}
\alias{plot.epiworld_hist_transition}
\title{Transition dynamics and incidence}
\usage{
get_hist_transition_matrix(x, skip_zeros = FALSE)

\method{as.array}{epiworld_hist_transition}(x, ...)

plot_incidence(x, ...)

\method{plot}{epiworld_hist_transition}(
  x,
  type = "b",
  xlab = "Day (step)",
  ylab = "Counts",
  main = "Daily incidence",
  plot = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{epiworld_sir}}, \code{\link{epiworld_seir}}, etc.
(any model), or an object of class \link{epiworld_hist_transition}.}

\item{skip_zeros}{Logical scalar. When \code{FALSE} it will return all the
entries in the transition matrix.}

\item{...}{In the case of plot methods, further arguments passed to
\link[graphics:plot.default]{graphics::plot}.}

\item{ylab, xlab, main, type}{Further parameters passed to \code{\link[graphics:plot.default]{graphics::plot()}}}

\item{plot}{Logical scalar. If \code{TRUE} (default), the function will plot the
desired statistic.}
}
\value{
\itemize{
\item \code{get_hist_transition_matrix} returns a \link{data.frame} with four columns:
"state_from", "state_to", "date", and "counts."
}

\itemize{
\item The \code{as.array} method for \code{epiworld_hist_transition} objects turns the
\code{data.frame} returned by \code{get_hist_transition_matrix} into an array of
\verb{nstates x nstates x (ndays + 1)}
entries, where the first entry is the initial state.
}

\itemize{
\item The \code{plot_incidence} function returns a plot originating from the object
\code{get_hist_transition_matrix}.
}

\itemize{
\item The \code{plot} method for \code{epiworld_hist_transition} returns a plot of the
daily incidence.
}
}
\description{
Functions to extract and visualize state transition counts, daily incidence,
and conversion to array format.
}
\details{
The \code{plot_incidence} function is a wrapper between
\link{get_hist_transition_matrix} and its plot method.

The plot method for the \code{epiworld_hist_transition} class plots the
daily incidence of each state. The function returns the data frame used for
plotting.
}
\examples{
# SEIR Connected model
seirconn <- ModelSEIRCONN(
  name              = "Disease",
  n                 = 10000,
  prevalence        = 0.1,
  contact_rate      = 2.0,
  transmission_rate = 0.8,
  incubation_days   = 7.0,
  recovery_rate     = 0.3
)

set.seed(937)
run(seirconn, 50)

# Get the transition history
t_hist <- get_hist_transition_matrix(seirconn)
head(t_hist)

# Convert to array
as.array(t_hist)[, , 1:3]

# Plot incidence
inci <- plot_incidence(seirconn)

}
\concept{Transition dynamics}
\concept{model-utility-functions}
