% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_saver.R
\name{run_multiple}
\alias{run_multiple}
\alias{run_multiple_get_results}
\alias{make_saver}
\alias{epiworld_saver}
\title{Run multiple simulations at once}
\usage{
run_multiple(
  m,
  ndays,
  nsims,
  seed = sample.int(10000, 1),
  saver = make_saver(),
  reset = TRUE,
  verbose = TRUE,
  nthreads = 1L
)

run_multiple_get_results(m)

make_saver(..., fn = "")
}
\arguments{
\item{m, ndays, seed}{See \link{run}.}

\item{nsims}{Integer. Number of replicats}

\item{saver}{An object of class \link{epiworld_saver}.}

\item{reset}{When \code{TRUE} (default,) resets the simulation.}

\item{verbose}{When \code{TRUE} (default,) prints a progress bar.}

\item{nthreads}{Integer. Number of threads (parallel computing.)}

\item{...}{List of strings (characters) specifying what to save (see details).}

\item{fn}{A file name pattern.}
}
\value{
\itemize{
\item In the case of \code{make_saver}, an list of class \code{epiworld_saver}.
}

\itemize{
\item The \code{run_multiple} function runs a specified number of simulations and
returns a model object of class \link{epiworld_model}.
}

\itemize{
\item The \code{run_multiple_get_results} function returns a named list with the
data specified by \code{make_saver}.
}
}
\description{
The \code{run_multiple} function allows running multiple simulations at once.
When available, users can take advantage of parallel computing to speed up
the process.
}
\details{
Currently, the following elements can be saved:
\itemize{
\item \code{total_hist} History of the model (total numbers per time).
\item \code{virus_info} Information about \code{viruses}.
\item \code{virus_hist} Changes in \code{viruses}.
\item \code{tool_info} Information about \code{tools}.
\item \code{tool_hist} Changes in \code{tools}.
\item \code{transmission} Transmission events.
\item \code{transition} Transition matrices.
\item \code{reproductive} Reproductive number.
\item \code{generation} Estimation of generation time.
}
}
\examples{
model_sir <- ModelSIRCONN(
  name = "COVID-19",
  prevalence = 0.01,
  n = 1000,
  contact_rate = 2,
  transmission_rate = 0.9, recovery_rate = 0.1
  )

# Generating a saver
saver <- make_saver("total_hist", "reproductive")

# Running and printing
run_multiple(model_sir, ndays = 100, nsims = 50, saver = saver, nthreads = 2)

# Retrieving the results
ans <- run_multiple_get_results(model_sir)

head(ans$total_hist)
head(ans$reproductive)

# Plotting
multi_sir <- run_multiple_get_results(model_sir)$total_hist
multi_sir <- multi_sir[multi_sir$date <= 20,]
plot(multi_sir)

}
