% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{with_option}
\alias{with_option}
\alias{with_silent}
\alias{with_verbose}
\alias{without_checking}
\title{Evaluate an expression with temporary eplusr options}
\usage{
with_option(opts, expr)

with_silent(expr)

with_verbose(expr)

without_checking(expr)
}
\arguments{
\item{opts}{A list of valid input for \code{eplusr::eplusr_option()}.}

\item{expr}{An expression to be evaluated.}
}
\description{
These functions evaluate an expression with temporary eplusr options
}
\details{
\code{with_option} evaluates an expression with specified eplusr options.

\code{with_silent} evaluates an expression with no verbose messages.

\code{with_verbose} evaluates an expression with verbose messages.

\code{without_checking} evaluates an expression with no checkings.
}
\examples{
\dontrun{
path_idf <- system.file("extdata/1ZoneUncontrolled.idf", package = "eplusr")

# temporarily disable verbose messages
idf <- with_silent(read_idf(path_idf, use_idd("8.8", download = "auto")))

# temporarily disable checkings
without_checking(idf$'BuildingSurface:Detailed' <- NULL)
# OR
with_option(list(validate_level = "none"), idf$'BuildingSurface:Detailed' <- NULL)
}

}
